/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import java.io.File;
import java.util.StringTokenizer;

public class McfCommand {
    public static final int SEQUENCE_NONE = 0;
    public static final int SEQUENCE_PRE_PROC = -1;
    public static final int SEQUENCE_POST_PROC = -2;
    public static final int TYPE_AEXEC = 1;
    public static final int TYPE_DEXEC = 2;
    private int type = 0;
    private String command = null;
    private int sequence = 0;

    public McfCommand(int type, String command) {
        this(type, command, 0);
    }

    public McfCommand(int type, String command, int sequence) {
        this.type = type;
        this.sequence = sequence;
        if (null == command) {
            command = "";
        }
        String commandPath = "";
        if (command.length() > 0 && File.separatorChar != command.charAt(0)) {
            StringTokenizer tokens = new StringTokenizer(command, "*= \t\n\r\f");
            String executable = "";
            if (tokens.hasMoreTokens()) {
                executable = tokens.nextToken();
                try {
                    commandPath = BaseFileControl.getFilePath(executable);
                }
                catch (HException he) {
                    // empty catch block
                }
            }
        }
        this.command = commandPath + command;
    }

    public String getCommand() {
        String cmd = "";
        if (null != this.command) {
            cmd = this.command;
        }
        return cmd;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String theString = "McfCommand([";
        if (null != this.command) {
            theString = theString + this.command;
        }
        theString = theString + "]," + this.type + "," + this.sequence + ")";
        return theString;
    }
}

